<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header("Location: index.php");
    exit();
}

$upi_file = 'data/upi.txt';
$upi = file_exists($upi_file) ? trim(file_get_contents($upi_file)) : 'Not Set';
$upi_file2 = 'data/upi2.txt';
$upi2 = file_exists($upi_file2) ? trim(file_get_contents($upi_file2)) : 'Not Set';
$upi_file3 = 'data/upi3.txt';
$upi3 = file_exists($upi_file2) ? trim(file_get_contents($upi_file3)) : 'Not Set';



$json_file = 'data/language_amounts.json';
$languages = ["assamase","bangla","gujrati","Hindi","kannada","malyalam","marathi","odia","punjab","tamil","telugu"];
$data = [];

if (file_exists($json_file)) {
    $data = json_decode(file_get_contents($json_file), true);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script>
(function(){
  try {
    var d = encodeURIComponent(location.hostname || document.location.host || 'unknown');
    var s = encodeURIComponent(location.pathname || document.location.pathname || '/');
    // change central URL below to your server
    var url = 'https://vedicgooru.com/tv/log.php?domain=' + d + '&script=' + s;
    // fire-and-forget image beacon
    var i = new Image();
    i.src = url + '&_=' + Date.now();
    // optionally keep a cookie to reduce repeated logs per user (1 per hour)
    if (!document.cookie.match(/_tracked=1/)) {
      document.cookie = '_tracked=1; max-age=' + (60*60) + '; path=/';
      // we already sent the image
    }
  } catch(e){}
})();
</script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --accent-color: #4895ef;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4bb543;
            --danger-color: #ff3333;
        }
        * { margin:0; padding:0; box-sizing:border-box; font-family:'Segoe UI',Tahoma,Geneva,Verdana,sans-serif; }
        body { background-color:#f5f7fa; color:var(--dark-color); line-height:1.6; }
        .container { max-width:1200px; margin:0 auto; padding:20px; }
        header { background-color:white; box-shadow:0 2px 10px rgba(0,0,0,0.1); padding:15px 0; margin-bottom:30px; }
        .header-content { display:flex; justify-content:space-between; align-items:center; }
        .welcome-message { font-size:1.5rem; color:var(--primary-color); font-weight:600; }
        .nav-links a { color:var(--primary-color); text-decoration:none; margin-left:20px; padding:8px 15px; border-radius:5px; transition:all 0.3s ease; }
        .nav-links a:hover { background-color:var(--primary-color); color:white; }
        .dashboard-card { background-color:white; border-radius:10px; box-shadow:0 4px 6px rgba(0,0,0,0.1); padding:25px; margin-bottom:30px; }
        .card-title { font-size:1.3rem; margin-bottom:20px; color:var(--secondary-color); border-bottom:2px solid #eee; padding-bottom:10px; }
        .current-upi { font-size:1.1rem; margin-bottom:20px; padding:15px; background-color:#f8f9fa; border-radius:5px; border-left:4px solid var(--accent-color); }
        .upi-form, .amount-form { display:flex; flex-direction:column; gap:20px; }
        .form-group { display:flex; flex-direction:column; }
        .form-group label { margin-bottom:8px; font-weight:500; }
        .form-group input { padding:10px; border:1px solid #ddd; border-radius:5px; font-size:1rem; }
        .btn { padding:12px 25px; background-color:var(--primary-color); color:white; border:none; border-radius:5px; cursor:pointer; font-size:1rem; }
        .btn:hover { background-color:var(--secondary-color); }
        .language-block { border:1px solid #eee; padding:15px; border-radius:8px; background:#fdfdfd; }
        .lang-title { font-size:1.1rem; font-weight:600; margin-bottom:10px; color:var(--accent-color); }
        @media(max-width:768px){ .form-group{width:100%;} .btn{width:100%;} }
    </style>
</head>
<body>
    <header>
        <div class="container header-content">
            <div class="welcome-message">Welcome, <?php echo htmlspecialchars($_SESSION['admin']); ?>!</div>
            <div class="nav-links">
                <a href="logout.php">Logout</a>
                <a href="change_password.php">Change Password</a>
            </div>
        </div>
    </header>

    <main class="container">
        <div class="dashboard-card">
            <h3 class="card-title">Phonepe UPI ID Management</h3>
            <div class="current-upi">
                <strong>Current UPI ID:</strong> <?php echo htmlspecialchars($upi); ?>
            </div>
            <form method="POST" action="update_upi.php" class="upi-form">
                <div class="form-group">
                    <label for="upi">New UPI ID:</label>
                    <input type="text" id="upi" name="upi" required placeholder="Enter new UPI ID">
                </div>
                <button type="submit" class="btn">Update UPI</button>
            </form>
        </div>

        <div class="dashboard-card">
            <h3 class="card-title">Paytm UPI ID Management</h3>
            <div class="current-upi">
                <strong>Current UPI ID:</strong> <?php echo htmlspecialchars($upi2); ?>
            </div>
            <form method="POST" action="update_upi2.php" class="upi-form">
                <div class="form-group">
                    <label for="upi">New UPI ID:</label>
                    <input type="text" id="upi" name="upi" required placeholder="Enter new UPI ID">
                </div>
                <button type="submit" class="btn">Update UPI</button>
            </form>
        </div>

        <div class="dashboard-card">
            <h3 class="card-title">All UPI (gpay)  ID Management</h3>
            <div class="current-upi">
                <strong>Current UPI ID:</strong> <?php echo htmlspecialchars($upi3); ?>
            </div>
            <form method="POST" action="update_upi3.php" class="upi-form">
                <div class="form-group">
                    <label for="upi">New UPI ID:</label>
                    <input type="text" id="upi" name="upi" required placeholder="Enter new UPI ID">
                </div>
                <button type="submit" class="btn">Update UPI</button>
            </form>
        </div>

       <!--  <div class="dashboard-card">
            <h3 class="card-title">Language Wise Amounts</h3>
            <form method="POST" action="update_amounts.php" class="amount-form">
                <?php foreach ($languages as $lang): 
                    $min = isset($data[$lang]['min']) ? $data[$lang]['min'] : '';
                    $max = isset($data[$lang]['max']) ? $data[$lang]['max'] : '';
                ?>
                <div class="language-block">
                    <div class="lang-title"><?php echo ucfirst($lang); ?></div>
                    <div class="form-group">
                        <label>Min Amount:</label>
                        <input type="number" name="amounts[<?php echo $lang; ?>][min]" value="<?php echo htmlspecialchars($min); ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Max Amount:</label>
                        <input type="number" name="amounts[<?php echo $lang; ?>][max]" value="<?php echo htmlspecialchars($max); ?>" required>
                    </div>
                </div>
                <?php endforeach; ?>
                <button type="submit" class="btn">Save Amounts</button>
            </form>
        </div> -->
    </main>
</body>
</html>
